/*
 * Decompiled with CFR 0.152.
 */
package bq_standard.rewards;

import betterquesting.api.api.QuestingAPI;
import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.rewards.IReward;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.IGuiPanel;
import betterquesting.api2.storage.DBEntry;
import bq_standard.AdminExecute;
import bq_standard.client.gui.rewards.PanelRewardCommand;
import bq_standard.rewards.factory.FactoryRewardCommand;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.advancements.FunctionManager;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.command.FunctionObject;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.CommandBlockBaseLogic;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class RewardCommand
implements IReward {
    public String command = "#Script Comment\nsay Running reward script...\nsay @s Claimed a reward";
    public String title = "bq_standard.reward.command";
    public String desc = "Run a command script";
    public boolean viaPlayer = false;
    public boolean hideIcon = true;
    public boolean asScript = true;

    public ResourceLocation getFactoryID() {
        return FactoryRewardCommand.INSTANCE.getRegistryName();
    }

    public String getUnlocalisedName() {
        return this.title;
    }

    public boolean canClaim(EntityPlayer player, DBEntry<IQuest> quest) {
        return true;
    }

    public void claimReward(EntityPlayer player, DBEntry<IQuest> quest) {
        Object sender;
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        UUID playerID = QuestingAPI.getQuestingUUID((EntityPlayer)player);
        String tmp = this.command.replaceAll("VAR_NAME", player.func_70005_c_());
        String finCom = tmp.replaceAll("VAR_UUID", playerID.toString());
        String[] comAry = finCom.split("\n");
        MinecraftServer server = player.field_70170_p.func_73046_m();
        Object object = sender = this.viaPlayer ? new AdminExecute(player) : new RewardCommandSender((Entity)player);
        if (this.asScript) {
            for (int i = 0; i < comAry.length; ++i) {
                if (!comAry[i].startsWith("/")) continue;
                comAry[i] = comAry[i].replaceFirst("/", "");
            }
            FunctionObject func = FunctionObject.func_193527_a((FunctionManager)server.func_193030_aL(), Arrays.asList(comAry));
            server.func_193030_aL().func_194019_a(func, (ICommandSender)sender);
        } else {
            server.func_71187_D().func_71556_a((ICommandSender)sender, finCom);
        }
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.command = nbt.func_74779_i("command");
        this.title = nbt.func_150297_b("title", 8) ? nbt.func_74779_i("title") : "bq_standard.reward.command";
        this.desc = nbt.func_150297_b("description", 8) ? nbt.func_74779_i("description") : "Run a command script";
        this.viaPlayer = nbt.func_74767_n("viaPlayer");
        this.hideIcon = !nbt.func_150297_b("hideBlockIcon", 1) || nbt.func_74767_n("hideBlockIcon");
        this.asScript = !nbt.func_150297_b("asScript", 1) || nbt.func_74767_n("asScript");
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74778_a("command", this.command);
        nbt.func_74778_a("title", this.title);
        nbt.func_74778_a("description", this.desc);
        nbt.func_74757_a("viaPlayer", this.viaPlayer);
        nbt.func_74757_a("hideBlockIcon", this.hideIcon);
        nbt.func_74757_a("asScript", this.asScript);
        return nbt;
    }

    public IGuiPanel getRewardGui(IGuiRect rect, DBEntry<IQuest> quest) {
        return new PanelRewardCommand(rect, this);
    }

    public GuiScreen getRewardEditor(GuiScreen screen, DBEntry<IQuest> quest) {
        return null;
    }

    public static class RewardCommandSender
    extends CommandBlockBaseLogic {
        private final Entity entity;

        private RewardCommandSender(@Nonnull Entity entity) {
            this.entity = entity;
        }

        @Nonnull
        public BlockPos func_180425_c() {
            return this.entity.func_180425_c();
        }

        @Nonnull
        public Vec3d func_174791_d() {
            return this.entity.func_174791_d();
        }

        @Nonnull
        public World func_130014_f_() {
            return this.entity.func_130014_f_();
        }

        public Entity func_174793_f() {
            return this.entity;
        }

        public void func_145756_e() {
        }

        public int func_145751_f() {
            return 0;
        }

        public void func_145757_a(@Nonnull ByteBuf p_145757_1_) {
        }

        @Nonnull
        public String func_70005_c_() {
            return "BetterQuesting";
        }

        public MinecraftServer func_184102_h() {
            return this.entity.func_184102_h();
        }
    }
}

